create or replace package body tbicds.PCK_RPT_CDE is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
   /*get Patient Cde Value*/
   procedure getPatientCdeValue (
      pi_vPatientID                     in varchar2,
      pi_vCdeID                         in varchar2,
      pi_nIntakeID                      in number,
      pi_vKey                           in varchar2,
      po_vValue                        out varchar2
      )
   is
      v_vSql                               varchar2(4000);
      rd                                   cde_stat_map%rowtype;
      v_vValue                             varchar2(128);
   begin
      v_vSql := 'select * from cde_stat_map where cde_id = :P0';
      execute immediate v_vSql into rd using pi_vCdeID;
   
      -- case: cde map type = Question
      if (rd.cde_map_type_id = 1)
         or (rd.cde_map_type_id = 3)
         or (rd.cde_map_type_id = 5)
      then
         v_vSql := 'select t.'||rd.field_name||' '
                   ||'from '||rd.table_name||' t '
                   ||'where t.patient_id = :P0 '
                   ||'and t.intake_id = :P1 '
                   ||'and t.mid = :P2 '
                   ||'and t.tid = :P3 '
                   ||'and t.qid = :P4 '
                   ||'and t.rid in (select s.rid from intake_response s where s.mid = t.mid and s.tid = t.tid and s.qid = t.qid) '
                   ||'and rownum = 1 ';
         execute immediate v_vSql into v_vValue using pi_vPatientID, pi_nIntakeID, rd.intake_mid, rd.intake_tid, rd.intake_qid;

      -- case: cde map type = Response
      elsif (rd.cde_map_type_id = 2)
      then
         null;
         
      -- case: cde map type = Score
      elsif (rd.cde_map_type_id = 3)
      then
         null;
         
      -- case: cde map type = Table
      elsif (rd.cde_map_type_id = 4)
      then
         if (instr(','||c_vEncrytedCdeIDs||',', ','||pi_vCdeID||',') > 0)
         then
            v_vSql := 'select '||rd.field_name||' from '||rd.table_name||' where patient_id = :P0';
            execute immediate v_vSql into v_vValue using pi_vPatientID;
            v_vValue := tbicds.ic_utl_sec.decryptdata (v_vValue, pi_vKey, pi_vPatientID);

            --? need to verify
            --if (rd.field_name like 'GENDER')
            --then
            --   v_vSql := 'select item from stat_data_collection where collection_type = :P0 and collection_item_id = :P1';
            --   execute immediate v_vSql into v_vValue using '_GENDER', v_vValue;*\
            --end if;
            
         else
            v_vSql := 'select wm_concat(s.item) '
                      ||'from '||rd.table_name||' t, stat_data_collection s '
                      ||'where t.patient_id = :P0 '
                      ||'and s.collection_type = :P1 '
                      ||'and t.'||rd.field_name||' = s.collection_item_id ';
            execute immediate v_vSql into v_vValue using pi_vPatientID, '_'||replace(rd.field_name, '_ID');
            
         end if;

      -- case: cde map type = Scale
      elsif (rd.cde_map_type_id = 5)
      then
         null;
         
      end if;
      
      po_vValue := v_vValue;
      
   exception
      when others 
      then 
         null;
   end;
      
   /*set Patient Cde: exclude encrypted demographic data */
   procedure setPatientCde (
      pi_vPatientID                     in varchar2 default null
      )
   is
      v_vSql                               varchar2(32767);
      rc1                                  sys_refcursor;
      rc2                                  sys_refcursor;
      rd                                   typ_obj_rpt_cde_pat;
      v_nIndex                             number;
      v_vPatientID                         varchar2(50);
      v_vCdeID                             varchar2(30);
      v_nIntakeID                          number(5);
      v_vValue                             varchar2(128);
   begin
      rd := typ_obj_rpt_cde_pat();
      
      -- part 1: add patient with intake data
      v_vSql := 'select distinct t.patient_id, t.intake_id from data_intake t '
                ||'where complete = 1'
                ||'and not exists (select * from patient_cde_rpt s where s.patient_id = t.patient_id and s.intake_id = t.intake_id) '
                ||case when (pi_vPatientID is not null) then 'and t.patient_id = '''||pi_vPatientID||''' ' end;
      open rc1 for v_vSql;
      loop
         fetch rc1 into v_vPatientID, v_nIntakeID;
         exit when rc1%notfound;
         v_nIndex := 0;
         
         begin
            --v_vSql := 'delete from patient_cde_rpt where patient_id = :P0 and intake_id = :P1';
            --execute immediate v_vSql using v_vPatientID, v_nIntakeID;
            
            v_vSql := 'select cde_id from cde_stat_map order by cde_id';
            open rc2 for v_vSql;
            loop
               fetch rc2 into v_vCdeID;
               exit when rc2%notfound;
               v_nIndex := v_nIndex + 1;
               
               -- exclude encrypted demographic data
               if (instr(','||c_vEncrytedCdeIDs||',', ','||v_vCdeID||',') = 0)
               then
                  getPatientCdeValue (v_vPatientID, v_vCdeID, v_nIntakeID, null, v_vValue);
                  rd.setValue(v_nIndex, v_vValue);
               end if;
            end loop;
            close rc2;
                   
            v_vSql := 'insert into patient_cde_rpt values (:P0, :P1, :P2, :P3)';
            execute immediate v_vSql using v_vPatientID, v_nIntakeID, sysdate, rd;
            commit;
            
         --exception
           -- when others
           -- then
             --  rollback;
         end;
      end loop;
      close rc1;

      -- part 2 (optional): add patient with no intake data
      v_vSql := 'select t.patient_id from patient_demographics t '
                ||'where 1 = '||c_nIncludeNoIntake||' '
                ||'and not exists (select * from patient_cde_rpt s where s.patient_id = t.patient_id) '
                ||case when (pi_vPatientID is not null) then 'and t.patient_id = '''||pi_vPatientID||''' ' end;
      open rc1 for v_vSql;
      loop
         fetch rc1 into v_vPatientID;
         exit when rc1%notfound;
         v_nIndex := 0;
         
         begin
            v_vSql := 'delete from patient_cde_rpt where patient_id = :P0';
            execute immediate v_vSql using v_vPatientID;
            
            v_vSql := 'select cde_id from cde_stat_map order by cde_id';
            open rc2 for v_vSql;
            loop
               fetch rc2 into v_vCdeID;
               exit when rc2%notfound;
               v_nIndex := v_nIndex + 1;
               
               -- exclude encrypted demographic data
               if (instr(','||c_vEncrytedCdeIDs||',', ','||v_vCdeID||',') = 0)
               then
                  getPatientCdeValue (v_vPatientID, v_vCdeID, null, null, v_vValue);
                  rd.setValue(v_nIndex, v_vValue);
               end if;
            end loop;
            close rc2;
                   
            v_vSql := 'insert into patient_cde_rpt values (:P0, :P1, :P2, :P3)';
            execute immediate v_vSql using v_vPatientID, -1, sysdate, rd;
            commit;
            
         exception
            when others
            then
               rollback;
         end;
      end loop;
      close rc1;      
   end;
      
   /*tabel Patient Cde */
   function tblPatientCde (
      pi_vKey                           in varchar2,
      pi_vProviderID                    in varchar2,
      pi_dDateRange_Start               in date,
      pi_dDateRange_End                 in date
      ) return                             typ_tbl_rpt_cde_pat pipelined
   is
      v_vSql                               varchar2(32767);
      rc1                                  sys_refcursor;
      rc2                                  sys_refcursor;
      rd                                   typ_obj_rpt_cde_pat;
      v_nIndex                             number;
      v_vPatientID                         varchar2(50);
      v_vCdeID                             varchar2(30);
      v_nIntakeID                          number(5);
      v_vValue                             varchar2(128);
   begin
      rd := typ_obj_rpt_cde_pat();

      v_vSql := 'select distinct t.patient_id, t.intake_id from data_intake t where t.complete = 1 '
                ||case 
                  when (c_nShowLatestIntake = 1) then 
                     'where t.intake_id = (select max(s.intake_id) from data_intake s where s.patient_id = t.patient_id) '
                  end;
      open rc1 for v_vSql;
      loop
         fetch rc1 into v_vPatientID, v_nIntakeID;
         exit when rc1%notfound;
         v_nIndex := 0;
         
         begin
            v_vSql := 'select cde_id from cde_stat_map order by cde_id';
            open rc2 for v_vSql;
            loop
               fetch rc2 into v_vCdeID;
               exit when rc2%notfound;
               v_nIndex := v_nIndex + 1;
               
               getPatientCdeValue (v_vPatientID, v_vCdeID, v_nIntakeID, pi_vKey, v_vValue);
               rd.setValue(v_nIndex, v_vValue);
            end loop;
            close rc2;
            
            pipe row (rd);
         exception
            when others
            then
               null;
         end;
      end loop;
      close rc1;
            
      -- part 2 (optional): add patient with no intake data
      v_vSql := 'select t.patient_id from patient_demographics t '
                ||'where 1 = '||c_nIncludeNoIntake||' '
                ||'and not exists (select * from data_intake s where s.patient_id = t.patient_id) ';
      open rc1 for v_vSql;
      loop
         fetch rc1 into v_vPatientID;
         exit when rc1%notfound;
         v_nIndex := 0;
         
         begin
            v_vSql := 'select cde_id from cde_stat_map order by cde_id';
            open rc2 for v_vSql;
            loop
               fetch rc2 into v_vCdeID;
               exit when rc2%notfound;
               v_nIndex := v_nIndex + 1;
               
               getPatientCdeValue (v_vPatientID, v_vCdeID, null, pi_vKey, v_vValue);
               rd.setValue(v_nIndex, v_vValue);
            end loop;
            close rc2;

            pipe row (rd);
            
         exception
            when others
            then
               null;
         end;
      end loop;
      close rc1; 

      return;
   end;

   /*table Patient Cde cache, use patient_cde_rpt table*/
   function tblPatientCde_Cached (
      pi_vKey                           in varchar2,
      pi_vProviderID                    in varchar2,
      pi_dDateRange_Start               in date,
      pi_dDateRange_End                 in date
      ) return                             typ_tbl_rpt_cde_pat pipelined
   is
      rd                                   typ_obj_rpt_cde_pat;
      v_vSql                               varchar2(32767);
      rc1                                  sys_refcursor;
      rc2                                  sys_refcursor;
      v_vPatientID                         varchar2(50);
      v_nIntakeID                          number(5);
      v_dDateUpdated                       date;
      v_nIndex                             number;
      v_vCdeID                             varchar2(30);
      v_vValue                             varchar2(128);
   begin
      rd := typ_obj_rpt_cde_pat();

      v_vSql := 'select t.* '
                ||'from patient_cde_rpt t '
                ||case 
                  when (c_nShowLatestIntake = 1) then 
                     'where t.intake_id = (select max(s.intake_id) from patient_cde_rpt s where s.patient_id = t.patient_id) '
                  end;
      open rc1 for v_vSql;
      loop
         fetch rc1 into v_vPatientID, v_nIntakeID, v_dDateUpdated, rd;
         exit when rc1%notfound;
         v_nIndex := 0;
         
         v_vSql := 'select cde_id from cde_stat_map order by cde_id';
         open rc2 for v_vSql;
         loop
            fetch rc2 into v_vCdeID;
            exit when rc2%notfound;
            v_nIndex := v_nIndex + 1;
         
            -- add encrypted demographic data
            if (instr(','||c_vEncrytedCdeIDs||',', ','||v_vCdeID||',') > 0)
            then
               getPatientCdeValue (v_vPatientID, v_vCdeID, v_nIntakeID, pi_vKey, v_vValue);
               rd.setValue(v_nIndex, v_vValue);
            end if;
         end loop;
         close rc2;
         
         pipe row (rd);
      end loop;
      close rc1;
      
      return;
   end;
   
   /*Get Patient Cde recordset*/
   procedure GetPatientCdeRS (
      pi_vSessionID                     in varchar2,
      pi_vSessionClientIP               in varchar2,
      pi_nUserID                        in number,
      --pi_nReportID                      in number,
      pi_vKey                           in varchar2,
      pi_vProviderID                    in varchar2,
      pi_vDateRange_Start               in varchar2,
      pi_vDateRange_End                 in varchar2,
      po_nStatusCode                   out number,
      po_vStatusComment                out varchar2,
      rs                               out sys_refcursor
      )
   is
      v_vSql                               varchar2(32767);
      rc                                   sys_refcursor;
      v_vVariableName                      varchar2(128);
      v_dDateRange_Start                   date := to_date(nvl(pi_vDateRange_Start, '19000101'), 'YYYYMMDD');
      v_dDateRange_End                     date := to_date(nvl(pi_vDateRange_End, '40001231'), 'YYYYMMDD');
      v_nIndex                             number := 0;
   begin
      open rc for 'select s.variable_name from cde_stat_map l, cde_stat s where l.cde_id = s.cde_id order by l.cde_id';
      loop
         fetch rc into v_vVariableName;
         exit when rc%notfound;
         
         v_nIndex := v_nIndex + 1;
         v_vSql := v_vSql
                   ||case when (v_vSql is not null) then ',' end
                   ||'c'||v_nIndex||' "'||substr(trim(v_vVariableName),1,30)||'"';
      end loop;
      close rc;
      
      v_vSql := 'select '||v_vSql||' from table (pck_rpt_cde.tblPatientCde (:P0,:P1,:P2,:P3)) t';
      open rs for v_vSql using pi_vKey, pi_vProviderID,v_dDateRange_Start,v_dDateRange_End;
  
   exception
      when others
      then
         po_nStatusCode    := Pck_Utl_Common.c_nResultStatus_Error;
         po_vStatusComment := 'PCK_RPT_CDE.GetPatientCdeRS(): '||sqlCode||'; '||sqlErrm;
   end;


   /*Get Patient Cde Cached recordset*/
   procedure GetPatientCdeRS_Cached (
      pi_vSessionID                     in varchar2,
      pi_vSessionClientIP               in varchar2,
      pi_nUserID                        in number,
      --pi_nReportID                      in number,
      pi_vKey                           in varchar2,
      pi_vProviderID                    in varchar2,
      pi_vDateRange_Start               in varchar2,
      pi_vDateRange_End                 in varchar2,
      po_nStatusCode                   out number,
      po_vStatusComment                out varchar2,
      rs                               out sys_refcursor
      )
   is
      v_vSql                               varchar2(32767);
      rc                                   sys_refcursor;
      v_vVariableName                      varchar2(128);
      v_dDateRange_Start                   date := to_date(nvl(pi_vDateRange_Start, '19000101'), 'YYYYMMDD');
      v_dDateRange_End                     date := to_date(nvl(pi_vDateRange_End, '40001231'), 'YYYYMMDD');
      v_nIndex                             number := 0;
   begin
      --setPatientCde ();
      
      open rc for 'select s.variable_name from cde_stat_map l, cde_stat s where l.cde_id = s.cde_id order by l.cde_id';
      loop
         fetch rc into v_vVariableName;
         exit when rc%notfound;
         
         v_nIndex := v_nIndex + 1;
         v_vSql := v_vSql
                   ||case when (v_vSql is not null) then ',' end
                   ||'c'||v_nIndex||' "'||substr(trim(v_vVariableName),1,30)||'"';
      end loop;
      close rc;
      
      v_vSql := 'select '||v_vSql||' from table (pck_rpt_cde.tblPatientCde_Cached (:P0,:P1,:P2,:P3)) t';
      open rs for v_vSql using pi_vKey, pi_vProviderID,v_dDateRange_Start,v_dDateRange_End;
  
   exception
      when others
      then
         po_nStatusCode    := Pck_Utl_Common.c_nResultStatus_Error;
         po_vStatusComment := 'PCK_RPT_CDE.GetPatientCdeRS_Cached(): '||sqlCode||'; '||sqlErrm;
   end;


end;
/

